//---------------------------------------------------------------------------
#ifndef Unit1H
#define Unit1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "FolderDialog.h"
#include "filename.h"
#include "mode.h"
#include "language.h"
#include <ComCtrls.hpp>
#include <IniFiles.hpp>
#include <Menus.hpp>
#include <winreg.h>
//---------------------------------------------------------------------------
#define EXTS_MAX 9
#define TRACK_IMAGE_REG_NAME "TARI.CD.Track.Image.File"
#define TRACK_IMAGE_REG_DESC "CD Track Image File"
#define FCD_REG_NAME "TARI.VirtualCD.Image.File"
#define FCD_REG_DESC "Virtual CD-ROM Image File"
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TButton *Button1;
    TButton *Button2;
    TFolderDialog *FolderDialog1;
    TPageControl *PageControl1;
    TTabSheet *FCD2ISO;
    TTabSheet *ISO2FCD;
    TGroupBox *GroupBox1;
    TRadioButton *iso_folder_specify;
    TRadioButton *iso_folder_same;
    TRadioButton *iso_folder_current;
    TEdit *iso_folder_name;
    TButton *iso_folder_ref;
    TGroupBox *GroupBox2;
    TCheckBox *regist;
    TCheckBox *warn;
    TCheckBox *verbose;
    TTabSheet *About;
    TGroupBox *GroupBox6;
    TLabel *Label1;
    TImage *Image1;
    TLabel *Label2;
    TLabel *Label3;
    TGroupBox *GroupBox3;
    TRadioButton *fcd_folder_specify;
    TRadioButton *fcd_folder_same;
    TRadioButton *fcd_folder_current;
    TEdit *fcd_folder_name;
    TButton *fcd_folder_ref;
    TCheckBox *fcd_create_sub_folder;
    TGroupBox *GroupBox4;
    TCheckBox *enable_mp3;
    TCheckBox *overwrite;
    TGroupBox *GroupBox5;
    TCheckBox *EXT1;
    TCheckBox *EXT2;
    TCheckBox *EXT3;
    TCheckBox *EXT4;
    TCheckBox *EXT5;
    TCheckBox *EXT6;
    TCheckBox *query_track_list;
    TPopupMenu *suffix_select;
    TMenuItem *image_suffix_1;
    TMenuItem *image_suffix_2;
    TMenuItem *image_suffix_3;
    TMenuItem *image_suffix_4;
    TGroupBox *GroupBox7;
    TRadioButton *block_size_2048;
    TRadioButton *block_size_2336;
    TRadioButton *block_size_2352;
    TLabel *Label4;
    TLabel *Label5;
    TLabel *Label6;
    TLabel *block_2048_suffix;
    TLabel *block_2336_suffix;
    TLabel *block_2352_suffix;
    TMenuItem *image_suffix_5;
    TCheckBox *EXT7;
    TCheckBox *EXT8;
    TCheckBox *EXT9;
    TScrollBox *ScrollBox1;
    TImage *Image2;
    TLabel *Label7;
    TLabel *Label8;
    TLabel *Label9;
    void __fastcall iso_folder_specifyClick(TObject *Sender);
    void __fastcall Button2Click(TObject *Sender);
    void __fastcall Button1Click(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall iso_folder_refClick(TObject *Sender);
    void __fastcall fcd_folder_specifyClick(TObject *Sender);
    void __fastcall fcd_folder_refClick(TObject *Sender);
    void __fastcall set_image_suffix(TObject *Sender);
private:	// [U[錾
    int language;
    int ini_version;
    TCheckBox *EXTS[EXTS_MAX];
    void __fastcall regist_fcd2iso();
    void __fastcall unregist_fcd2iso();
    void __fastcall regist_iso2fcd(char *ext);
    void __fastcall unregist_iso2fcd(char *ext);
    char * __fastcall check_ole_class(char *ext);
    int __fastcall new_ole_class(char *ext, char *ole_class);
    int __fastcall add_shell_command(char *ole_class, char *category, char *caption, char *option);
    int __fastcall set_ole_class_description(char *ole_class, char *description);
    int __fastcall set_ole_class_default_icon(char *ole_class, int icon_index);
    void __fastcall error_class_register(char *ext);
    int __fastcall remove_shell_command(char *ole_class, char *category);
    int __fastcall remove_registry_key_recursive(HKEY k, char *subkey);
    int __fastcall release_win2k_ext_binding(char *ext);
    void __fastcall set_language();
    AnsiString __fastcall long_path(AnsiString filename);
public:		// [U[錾
    __fastcall TForm1(TComponent* Owner);
    char * __fastcall get_iso_folder(char *fcd_file);
    char * __fastcall get_fcd_folder(char *iso_file);
    int __fastcall get_mode();
    void __fastcall run_fcdutil();
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
